@echo off
SETLOCAL EnableDelayedExpansion

:: === CONFIGURAÇÕES ===
SET "JRE_PATH=C:\Java\jre"
SET "JAVA_EXE=%JRE_PATH%\bin\java.exe"
SET "JAVAW_EXE=%JRE_PATH%\bin\javaw.exe"
SET "TEMP_LOG=%temp%\jre_install.log"

:: === VERIFICAÇÃO DE ADMINISTRADOR ===
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo [ERRO] Execute como Administrador!
    pause
    exit /b
)

:: === VERIFICAR SE JRE EXISTE ===
if not exist "%JAVA_EXE%" (
    echo [ERRO] Java.exe nao encontrado em: %JAVA_EXE%
    echo Certifique-se de que o JRE esta instalado no diretorio correto.
    pause
    exit /b
)

:: === MENU PRINCIPAL ===
:MAIN_MENU
cls
echo.
echo ================================================================================
echo                             CONFIGURAR JRE NO SISTEMA
echo ================================================================================
echo 01/2026
echo by Gabriel Mendonca
echo Instagram..:
echo Website....: www.basiliskplusplus.com
echo.
echo.
echo Esta e uma Java Runtime Environment (JRE) personalizada, criada atraves da 
echo ferramenta jlink a partir do Oracle JDK 17 com integração completa do JavaFX 17. 
echo Ela foi otimizada para fornecer um ambiente modular e eficiente para execução de 
echo aplicacoes Java, incluindo aquelas que utilizam a tecnologia JavaFX.
echo.
echo.
echo Nota: antes de iniciar a opcao 1 e configurar sertifique-se de que o java esteja no
echo local certo no seu Sistema, local : C:\Java\jre
echo.
echo       + MENU +
echo.
echo 1 - CONFIGURAR JRE
echo 2 - REMOVER CONFIGURACOES DA JRE
echo 3 - VERIFICAR CONFIGURACAO
echo 4 - SAIR
echo.
set /p choice="Escolha uma opcao [1-4]: "

if "%choice%"=="1" goto INSTALL
if "%choice%"=="2" goto REMOVE
if "%choice%"=="3" goto CHECK
if "%choice%"=="4" exit
goto MAIN_MENU

:: === INSTALAÇÃO ===
:INSTALL
echo Instalando associacoes para JRE em: %JRE_PATH%
echo Instalação iniciada: %date% %time% > "%TEMP_LOG%"

set "steps=5"
set "bar_width=40"

for /L %%p in (1,1,%steps%) do (
    set /a "percent=%%p*100/%steps%"
    set /a "filled=(%%p*bar_width)/%steps%"
    set /a "empty=bar_width-filled"
    
    if %%p==1 (
        set "task=Configurando variavel JAVA_HOME..."
        reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "JAVA_HOME" /t REG_EXPAND_SZ /d "%JRE_PATH%" /f >> "%TEMP_LOG%" 2>&1
        echo Etapa 1: JAVA_HOME configurada >> "%TEMP_LOG%"
    )
    
    if %%p==2 (
        set "task=Atualizando PATH do sistema..."
        for /f "tokens=2,*" %%A in ('reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v Path 2^>nul') do set "current_path=%%B"
        if not defined current_path (
            set "current_path="
        )
        echo PATH atual: !current_path! >> "%TEMP_LOG%"
        
        :: Verificar se JRE já está no PATH
        echo !current_path! | find /i "%JRE_PATH%\bin" > nul
        if errorlevel 1 (
            set "new_path=!current_path!;%JRE_PATH%\bin"
            reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v Path /t REG_EXPAND_SZ /d "!new_path!" /f >> "%TEMP_LOG%" 2>&1
            echo JRE adicionado ao PATH >> "%TEMP_LOG%"
        ) else (
            echo JRE ja esta no PATH >> "%TEMP_LOG%"
        )
    )
    
    if %%p==3 (
        set "task=Criando associacao .jar..."
        assoc .jar=JarFile >> "%TEMP_LOG%" 2>&1
        if errorlevel 1 (
            echo ERRO na associacao .jar >> "%TEMP_LOG%"
        ) else (
            echo Associacao .jar criada com sucesso >> "%TEMP_LOG%"
        )
    )
    
    if %%p==4 (
        set "task=Configurando execucao de arquivos JAR..."
        ftype JarFile="%JAVAW_EXE%" -jar "%%1" %%* >> "%TEMP_LOG%" 2>&1
        if errorlevel 1 (
            echo ERRO no ftype JarFile >> "%TEMP_LOG%"
        ) else (
            echo Ftype configurado com sucesso >> "%TEMP_LOG%"
        )
    )
    
    if %%p==5 (
        set "task=Configurando registro do Windows..."
        :: Criar entrada completa para JarFile
        reg add "HKEY_CLASSES_ROOT\.jar" /ve /t REG_SZ /d "JarFile" /f >> "%TEMP_LOG%" 2>&1
        reg add "HKEY_CLASSES_ROOT\JarFile" /ve /t REG_SZ /d "Arquivo Java JAR" /f >> "%TEMP_LOG%" 2>&1
        reg add "HKEY_CLASSES_ROOT\JarFile\DefaultIcon" /ve /t REG_SZ /d "%JAVA_EXE%,0" /f >> "%TEMP_LOG%" 2>&1
        reg add "HKEY_CLASSES_ROOT\JarFile\shell\open\command" /ve /t REG_SZ /d "\"%JAVAW_EXE%\" -jar \"%%1\" %%*" /f >> "%TEMP_LOG%" 2>&1
        echo Registro configurado completamente >> "%TEMP_LOG%"
    )

    set "bar="
    for /L %%i in (1,1,!filled!) do set "bar=!bar!#"
    set "rest="
    for /L %%i in (1,1,!empty!) do set "rest=!rest!"

    cls
    echo [INSTALACAO JRE - ASSOCIACOES]
    echo.
    echo [!percent!%%] !task!
    echo [!bar!!rest!]
    timeout /t 1 >nul
)

echo.
echo [SUCESSO] Configuracao concluida!
echo [INFO] Variaveis configuradas no SISTEMA (todos os usuarios)
echo [INFO] Associacoes de arquivo .jar criadas
echo [LOG] Detalhes salvos em: %TEMP_LOG%
echo [AVISO] Reinicie o computador para aplicar completamente
echo.
echo Teste rapido da associacao:
assoc .jar
ftype JarFile
pause
goto MAIN_MENU

:: === REMOÇÃO ===
:REMOVE
echo Removendo configuracao do JRE...
echo Remocao iniciada: %date% %time% >> "%TEMP_LOG%"

set "steps=6"
set "bar_width=40"

for /L %%p in (1,1,%steps%) do (
    set /a "percent=%%p*100/%steps%"
    set /a "filled=(%%p*bar_width)/%steps%"
    set /a "empty=bar_width-filled"
    
    if %%p==1 (
        set "task=Removendo JAVA_HOME..."
        reg delete "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "JAVA_HOME" /f >> "%TEMP_LOG%" 2>&1
        echo JAVA_HOME removida >> "%TEMP_LOG%"
    )
    
    if %%p==2 (
        set "task=Removendo do PATH..."
        for /f "tokens=2,*" %%A in ('reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v Path 2^>nul') do set "current_path=%%B"
        if defined current_path (
            set "new_path=!current_path: %JRE_PATH%\bin=!"
            set "new_path=!new_path:;%JRE_PATH%\bin=;!"
            set "new_path=!new_path:;;=;!"
            reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v Path /t REG_EXPAND_SZ /d "!new_path!" /f >> "%TEMP_LOG%" 2>&1
        )
        echo JRE removido do PATH >> "%TEMP_LOG%"
    )
    
    if %%p==3 (
        set "task=Removendo associacao .jar..."
        assoc .jar= >> "%TEMP_LOG%" 2>&1
        echo Associacao .jar removida >> "%TEMP_LOG%"
    )
    
    if %%p==4 (
        set "task=Removendo configuracao de execucao..."
        ftype JarFile= >> "%TEMP_LOG%" 2>&1
        echo Ftype removido >> "%TEMP_LOG%"
    )
    
    if %%p==5 (
        set "task=Limpando registro..."
        reg delete "HKEY_CLASSES_ROOT\.jar" /f >> "%TEMP_LOG%" 2>&1
        reg delete "HKEY_CLASSES_ROOT\JarFile" /f >> "%TEMP_LOG%" 2>&1
        echo Registro limpo >> "%TEMP_LOG%"
    )
    
    if %%p==6 (
        set "task=Atualizando explorador..."
        :: Forçar atualização do explorer
        taskkill /f /im explorer.exe >> "%TEMP_LOG%" 2>&1
        start explorer.exe >> "%TEMP_LOG%" 2>&1
        echo Explorer reiniciado >> "%TEMP_LOG%"
    )

    set "bar="
    for /L %%i in (1,1,!filled!) do set "bar=!bar!#"
    set "rest="
    for /L %%i in (1,1,!empty!) do set "rest=!rest!▒"

    cls
    echo [REMOCAO JRE]
    echo.
    echo [!percent!%%] !task!
    echo [!bar!!rest!]
    timeout /t 1 >nul
)

echo.
echo [SUCESSO] Remocao concluida!
echo [INFO] Associacoes removidas do sistema
echo [LOG] Detalhes salvos em: %TEMP_LOG%
pause
goto MAIN_MENU

:: === VERIFICAÇÃO ===
:CHECK
cls
echo ========================================
echo    VERIFICACAO DA INSTALACAO JRE
echo ========================================
echo.

echo [ARQUIVO JAVA.EXE]
if exist "%JAVA_EXE%" (
    echo ✓ Java.exe encontrado: %JAVA_EXE%
    "%JAVA_EXE%" -version 2>&1 | findstr /i "version"
) else (
    echo ✗ Java.exe NAO encontrado: %JAVA_EXE%
)

echo.
echo [VARIAVEIS DE SISTEMA]
reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "JAVA_HOME" >nul 2>&1
if %errorLevel% equ 0 (
    echo ✓ JAVA_HOME definida no SISTEMA
    for /f "tokens=2,*" %%A in ('reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "JAVA_HOME" 2^>nul') do echo   Valor: %%B
) else (
    echo ✗ JAVA_HOME nao encontrada
)

echo.
echo [PATH DO SISTEMA]
set "jre_in_path=0"
for /f "tokens=2,*" %%A in ('reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "Path" 2^>nul') do (
    echo %%B | find /i "%JRE_PATH%\bin" >nul && set "jre_in_path=1"
)
if !jre_in_path! equ 1 (
    echo ✓ JRE encontrado no PATH do SISTEMA
) else (
    echo ✗ JRE nao encontrado no PATH
)

echo.
echo [ASSOCIACOES DE ARQUIVO]
assoc .jar >nul 2>&1
if %errorLevel% equ 0 (
    echo ✓ Associacao .jar configurada
    for /f "tokens=2 delims==" %%A in ('assoc .jar 2^>nul') do echo   Tipo: %%A
) else (
    echo ✗ Associacao .jar nao encontrada
)

echo.
echo [CONFIGURACAO DE EXECUCAO]
ftype JarFile >nul 2>&1
if %errorLevel% equ 0 (
    echo ✓ Configuracao de execucao ativa
    for /f "tokens=2*" %%A in ('ftype JarFile 2^>nul') do echo   Comando: %%A %%B
) else (
    echo ✗ Configuracao de execucao nao encontrada
)

echo.
echo [REGISTRO WINDOWS]
reg query "HKEY_CLASSES_ROOT\.jar" /ve >nul 2>&1
if %errorLevel% equ 0 (
    echo ✓ Entrada .jar no registro
) else (
    echo ✗ Entrada .jar faltando no registro
)

reg query "HKEY_CLASSES_ROOT\JarFile" >nul 2>&1
if %errorLevel% equ 0 (
    echo ✓ Entrada JarFile no registro
) else (
    echo ✗ Entrada JarFile faltando no registro
)

echo.
pause
goto MAIN_MENU
